#!/bin/sh

# Script to improve filenames of WSDL exported from SoapUI.
# Loop over directories containing .wsdl .xsd files
for i in *
do 
	# Only operate on directories that exist, ignoring files.
	if [ -d "$i" ]
	then
		cd $i
		
		# List xsd or wsdl files including those that start with a dot
		ls -a | egrep 'xsd|wsdl' | while read a
		do
			# Rename file by removing sequence ending in underscore and prefixing with current directory name
			n=$i$(echo $a | sed -e 's/^.*_//')
			mv $a $n

			# Edit the "schemaLocation" and "location" elements (both end in "ocation")

			# Remove the sequences ending in an underscore
			sed -i 's/ocation="[^.]*_/ocation="/g' $n

			# Add the current directory name
			sed -i 's/ocation="/ocation="'$i'/g' $n
		done
		
		cd ..
	fi
done

